# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 10
# Experiment: PMxPM, Run: 4
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR10_strategy.txt
# LLM Suggested Fallback: C

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR10(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    
    # Early Rounds (1-3)
    if current_round <= 3:
        if not opp_history:  # First move
            return "C"
        else:
            if "D" in opp_history:
                return "D"
            else:
                return "C"
    
    # Middle Rounds (4-7)
    elif 4 <= current_round <= 7:
        if "D" in opp_history[:3]:
            return opp_history[-1]
        else:
            if "D" in opp_history[3:current_round-1]:
                return opp_history[-1]
            else:
                return "C"
    
    # Late Rounds (8-10)
    else:
        coop_count = opp_history.count("C")
        defect_count = opp_history.count("D")
        
        if coop_count >= 5:
            return "C"
        elif defect_count > 5:
            return "D"
        else:
            # Alternate between C and D to confuse the opponent
            return "D" if current_round % 2 == 0 else "C"